#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"
#include "textures.inc"

// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=128;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128*100
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2*3
	}


// ---light setting---
light_source {
	<40,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare hodou_texture=texture{pigment{color IndianRed}finish {ambient 0.3}}
#declare base_width=0;
#declare pipe_d=1;
#declare pipe_end_d=.75;
#declare dock_hight=16;
#declare pipeline_hight=8;
#declare pipeline_ring_r=3;
#declare pipe_connection_position=8;
#declare pipe_ring=
intersection{
	object{torus {
		pipeline_ring_r,pipe_d // major radius, minor radius			
	}rotate<90,0,0>
	translate<0,0,0>}
	object{box{<-paksize/2,0,-paksize/4>,<0,paksize/4,paksize/4>}}
}
#declare pipe_ring_short=
intersection{
	object{torus {
		pipe_end_d,pipe_end_d // major radius, minor radius			
	}rotate<0,0,90>
	translate<0,0,0>}
	object{box{<-paksize/4,0,0>,<paksize/4,paksize/4,paksize/2>}}
}
#declare pipe_dock=
object{
	pipe_ring
	translate<paksize/2,dock_hight,0>
	texture{Silver3}
}
#declare pipe_center=
object{
	merge{
		object{
			pipe_ring
			rotate<0,0,-90>
			translate<0,dock_hight,0>
		}
		object{
			cylinder {
				<pipeline_ring_r,pipeline_hight+pipeline_ring_r+pipe_d,0>,<pipeline_ring_r,dock_hight,0>,pipe_d // center of one end, center of other end, radius
			}
		}
		object{
			pipe_ring
			rotate<0,0,90>
			translate<pipeline_ring_r*2,pipeline_hight+pipeline_ring_r+pipe_d,0>
		}
		object{
			cylinder {
				<pipeline_ring_r*2,pipeline_hight+pipe_d,0>,<paksize/2,pipeline_hight+pipe_d,0>,pipe_d // center of one end, center of other end, radius
			}
		}
	}
	texture{Silver3}
}
#declare uki_width=14;
#declare uki_size=8;
#declare uki=
object{
	merge{
		object{box{<-uki_size/2,0,-uki_width/2>,<uki_size/2,pipeline_hight,uki_width/2>}}
		object{box{<-pipe_d,pipeline_hight+pipe_d*2,uki_width/2-pipe_d*2>,<pipe_d,pipeline_hight,uki_width/2>}}
	}
	texture{pigment{color Gray90}}
}
#declare uki_with_black=
object{
	merge{
		object{box{<-uki_size/2,0,-uki_size/2>,<uki_size/2,pipeline_hight,uki_size/2>}
		texture{pigment{color Gray90}}}
		object{
			box{<1,0,1>,<-1,pipeline_hight-1,-1>}
			translate<uki_size/2,0,uki_size/2>
		}
		object{
			box{<1,0,1>,<-1,pipeline_hight-1,-1>}
			translate<uki_size/2,0,-uki_size/2>
		}
	}
}
#declare ship_width=22;
#declare pipe_end_pos=12;
#declare pipe_end=
object{
	merge{
		object{
			cylinder {
				<0,pipeline_hight+pipe_d,0>,<pipe_end_pos-pipeline_ring_r,pipeline_hight+pipe_d,0>,pipe_d // center of one end, center of other end, radius
			}
		}
	}
	texture{Silver3}
}
#declare pipe_connection_height1=6;
#declare pipe_connection_height2=20;
#declare pipe_connection_length1=15;
#declare pipe_connection_length2=15;
#declare pipe_connection_angle=8;
#declare pipe_connection_end=
object{
	merge{
	cylinder{<0,-pipe_connection_length1,0>,<0,pipe_connection_length2,0>,pipe_end_d}
	cylinder{<0,pipe_connection_length2,0>,<0,pipe_connection_length2-1,0>,pipe_end_d*1.5}
	}
	rotate<0,0,pipe_connection_angle>
}
#declare pipe_connection=
object{
	merge{
		object{cylinder{<0,pipeline_hight,0>,<0,pipeline_hight+pipe_d*2,0>,pipe_d*2}}
		object{cylinder{<0,pipeline_hight,0>,<0,pipeline_hight+pipe_connection_height1,0>,pipe_end_d}}
		object{pipe_ring_short
		translate<0,pipeline_hight+pipe_connection_height1,-pipe_end_d>}
		object{cylinder{<0,pipeline_hight+pipe_connection_height1+pipe_end_d*2,-pipe_end_d*2>,<0,pipeline_hight+pipe_connection_height2,-pipe_end_d*2>,pipe_end_d}}
		object{pipe_ring_short
		rotate<180,0,0>
		translate<0,pipeline_hight+pipe_connection_height1+pipe_end_d*2,-pipe_end_d>}
		object{pipe_connection_end
		translate<0,pipeline_hight+pipe_connection_height2,0>}
	}
	texture{pigment{color White}}
}
// connect main pipe and connectance
#declare pipe_end_connection=
object{
	merge{
		object{cylinder{<0,pipeline_hight+pipe_d,0>,<-(paksize/4-ship_width/2-pipe_end_pos+pipeline_ring_r),pipeline_hight+pipe_d,0>,pipe_d}
		translate<paksize/4-ship_width/2-2,0,0>}
		object{cylinder{<0,pipeline_hight+pipe_d,0>,<-(paksize/4-ship_width/2-pipe_end_pos-pipeline_ring_r),pipeline_hight+pipe_d,0>,pipe_d}
		translate<paksize/4-ship_width/2-2,0,pipe_connection_position>}
		object{cylinder{<0,pipeline_hight+pipe_d,0>,<-(paksize/4-ship_width/2-pipe_end_pos-pipeline_ring_r),pipeline_hight+pipe_d,0>,pipe_d}
		translate<paksize/4-ship_width/2-2,0,-pipe_connection_position>}
		object{pipe_ring
		rotate<0,0,180>
		rotate<90,0,0>
		translate<pipe_end_pos-pipeline_ring_r,pipeline_hight+pipe_d,pipe_d*2+pipeline_ring_r>}
		object{pipe_ring
		rotate<0,0,180>
		rotate<-90,0,0>
		translate<pipe_end_pos-pipeline_ring_r,pipeline_hight+pipe_d,-pipe_d*2-pipeline_ring_r>}
		object{pipe_ring
		rotate<0,0,180>
		rotate<90,0,0>
		rotate<0,180,0>
		translate<pipe_end_pos+pipeline_ring_r,pipeline_hight+pipe_d,pipe_d*2+pipeline_ring_r>}
		object{pipe_ring
		rotate<0,0,180>
		rotate<-90,0,0>
		rotate<0,180,0>
		translate<pipe_end_pos+pipeline_ring_r,pipeline_hight+pipe_d,-pipe_d*2-pipeline_ring_r>}
	}
	texture{Silver3}
}
#declare uki_end_width=24;
#declare uki_end=
merge{
	object{
		merge{
			object{box{<8-uki_size/2,0,uki_end_width/2>,<paksize/4-ship_width/2,pipeline_hight,-uki_end_width/2>}}
		}
		texture{pigment{color Gray90}}
	}
	object{
		box{<1,0,1>,<-1,pipeline_hight-1,-1>}
		translate<paksize/4-ship_width/2,0,-uki_end_width/2>
	}
	object{
		box{<1,0,1>,<-1,pipeline_hight-1,-1>}
		translate<paksize/4-ship_width/2,0,0>
	}
	object{
		box{<1,0,1>,<-1,pipeline_hight-1,-1>}
		translate<paksize/4-ship_width/2,0,uki_end_width/2>
	}
}

#declare base_white_line=
object{
	difference{
		object{box{<3,.01,32-16>,<29,.0,32+16>}}
		object{box{<3+2,.02,32-16+2>,<29-2,-.01,32+16-2>}}
	}
	texture{pigment{color White}}
}


#declare obj=
object{
	merge{
		object{pipe_dock
		translate<0,0,paksize/4>}
		object{pipe_dock
		translate<0,0,paksize/4+pipe_d*2>}
		object{pipe_dock
		translate<0,0,paksize/4-pipe_d*2>}
		// object{box{<0,0,0>,<paksize/2,dock_hight,paksize/2>}}
	}
}

#declare obj2=
object{
	merge{
		object{pipe_center
		translate<0,0,paksize/4>}
		object{pipe_center
		translate<0,0,paksize/4+pipe_d*2>}
		object{pipe_center
		translate<0,0,paksize/4-pipe_d*2>}
		object{uki
		translate<8,0,paksize/4>}
		object{uki
		translate<24,0,paksize/4>}
		object{uki
		translate<40,0,paksize/4>}
		object{uki
		translate<56,0,paksize/4>}
		object{box{<0,pipeline_hight+pipe_d*2,paksize/4+pipe_d*3>,<paksize/2,pipeline_hight+pipe_d*2+.1,paksize/4+pipe_d*5>}texture{hodou_texture}}
		object{box{<0,dock_hight-1,paksize/4+pipe_d*3>,<0.01,dock_hight-2,paksize/4+pipe_d*5>}texture{hodou_texture}}
		object{box{<0,dock_hight-3,paksize/4+pipe_d*3>,<0.01,dock_hight-4,paksize/4+pipe_d*5>}texture{hodou_texture}}
		object{box{<0,dock_hight-5,paksize/4+pipe_d*3>,<0.01,dock_hight-6,paksize/4+pipe_d*5>}texture{hodou_texture}}
	}
}
#declare obj3=
object{
	merge{
		object{pipe_end
		translate<0,0,paksize/4>}
		object{pipe_end
		translate<0,0,paksize/4+pipe_d*2>}
		object{pipe_end
		translate<0,0,paksize/4-pipe_d*2>}
		object{uki_end
		translate<0,0,paksize/4>}
		object{pipe_connection
		translate<paksize/4-ship_width/2-2,0,paksize/4>}
		object{pipe_connection
		translate<paksize/4-ship_width/2-2,0,paksize/4-pipe_connection_position>}
		object{pipe_connection
		translate<paksize/4-ship_width/2-2,0,paksize/4+pipe_connection_position>}
		object{pipe_end_connection
		translate<0,0,paksize/4>}
		object{uki_with_black
		translate<paksize/4-ship_width/2-uki_size/2,0,paksize/2*0+uki_size/2>}
		object{uki_with_black
		translate<paksize/4-ship_width/2-uki_size/2,0,paksize/2*1-uki_size/2>}
		object{box{<0,pipeline_hight+pipe_d*2,paksize/4+pipe_d*3>,<paksize/4-ship_width/2-uki_size,pipeline_hight+pipe_d*2+.1,paksize/4+pipe_d*5>}texture{hodou_texture}}
		object{box{<paksize/4-ship_width/2-uki_size,pipeline_hight+pipe_d*2,uki_size-2>,<paksize/4-ship_width/2-uki_size+pipe_d*2,pipeline_hight+pipe_d*2+.1,paksize/2-uki_size+2>}texture{hodou_texture}}
		object{naname(<paksize/4-ship_width/2-uki_size+pipe_d,pipeline_hight+pipe_d*2,uki_size-2>,<paksize/4-ship_width/2-uki_size+pipe_d,pipeline_hight,3>,pipe_d*2,.01)texture{hodou_texture}}
		object{naname(<paksize/4-ship_width/2-uki_size+pipe_d,pipeline_hight+pipe_d*2,paksize/2-uki_size+2>,<paksize/4-ship_width/2-uki_size+pipe_d,pipeline_hight,paksize/2-3>,pipe_d*2,.01)texture{hodou_texture}}
		object{box{<4,pipeline_hight+pipe_d*2,paksize/4+pipe_d*3>,<6,pipeline_hight,paksize/4+pipe_d*5>}texture{pigment{color Gray90}}}
		object{box{<paksize/4-ship_width/2-uki_size,pipeline_hight,uki_size-2>,<paksize/4-ship_width/2-uki_size+pipe_d*2,pipeline_hight+pipe_d*2,uki_size>}texture{pigment{color Gray90}}}
		object{box{<paksize/4-ship_width/2-uki_size,pipeline_hight,paksize/4-uki_end_width/2+2>,<paksize/4-ship_width/2-uki_size+pipe_d*2,pipeline_hight+pipe_d*2,paksize/4-uki_end_width/2>}texture{pigment{color Gray90}}}
		object{box{<paksize/4-ship_width/2-uki_size,pipeline_hight,paksize/4+uki_end_width/2-2>,<paksize/4-ship_width/2-uki_size+pipe_d*2,pipeline_hight+pipe_d*2,paksize/4+uki_end_width/2>}texture{pigment{color Gray90}}}
	}
}





// object{
// merge{
// 	object{obj}
// 	object{obj2
// 	translate<paksize/2,0,0>}
// 	object{obj3
// 	translate<paksize,0,0>}
// 	object{box{<0,0,0>,<paksize/2,dock_hight,paksize/2>}texture{pigment{color Gray90}}}
// }
// scale .5
// }




// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
object{
	obj
}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,20,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0.1,paksize*int_x/4-base_width-.5>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_z,int_y)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,20,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4-base_width-.5,0.1,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
#declare output_area_set_x_2=
#if(make_front_image)
object{merge{box{<0-0.1,20,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0.1,paksize*int_x/4+base_width+.5>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_z,int_y)+2)/2>}}
#end
#declare output_area_set_z_2=
#if(make_front_image)
object{merge{box{<-paksize,20,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4+base_width+.5,0.1,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x_2}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z_2}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<-1,0,-1>*paksize
}
#declare output_obj=
object{
	obj2
}
#declare make_front_image = 0;
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-10.1,20,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-10.11,0.1,paksize*int_x/4-base_width-.5>,<paksize*int_y/2+10.11,paksize*int_z,paksize*int_x/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_z,int_y)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,20,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4-base_width-.5,0.1,0-10.11>,<paksize*int_x/2+10.11,paksize*int_z,paksize*int_y/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
#declare output_area_set_x_2=
#if(make_front_image)
object{merge{box{<0-0.1,20,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-10.11,0.1,paksize*int_x/4+base_width+.5>,<paksize*int_y/2+10.11,paksize*int_z,paksize*int_x/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_z,int_y)+2)/2>}}
#end
#declare output_area_set_z_2=
#if(make_front_image)
object{merge{box{<-paksize,20,-paksize>,<paksize*(int_x+2)/2+10.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4+base_width+.5,0.1,0-10.11>,<paksize*int_x/2+10.11,paksize*int_z,paksize*int_y/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x_2}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z_2}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
#declare output_obj=
object{
	obj3
}
#declare make_front_image = 0;
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-10.1,20,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-10.11,0.1,paksize*int_x/4-base_width-.5>,<paksize*int_y/2+10.11,paksize*int_z,paksize*int_x/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_z,int_y)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,20,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4-base_width-.5,0.1,0-10.11>,<paksize*int_x/2+10.11,paksize*int_z,paksize*int_y/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
#declare output_area_set_x_2=
#if(make_front_image)
object{merge{box{<0-0.1,20,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-10.11,0.1,paksize*int_x/4+base_width+.5>,<paksize*int_y/2+10.11,paksize*int_z,paksize*int_x/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_z,int_y)+2)/2>}}
#end
#declare output_area_set_z_2=
#if(make_front_image)
object{merge{box{<-paksize,20,-paksize>,<paksize*(int_x+2)/2+10.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4+base_width+.5,0.1,0-10.11>,<paksize*int_x/2+10.11,paksize*int_z,paksize*int_y/2+10.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x_2}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z_2}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*paksize
}
