#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"

// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=128;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128*1000
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2*3
	}


// ---light setting---
light_source {
	<0,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare dam_tri=
object{
	intersection{
		object{box{<sqrt(2)/2,sqrt(2)/2,.5>,<-sqrt(2)/2,-sqrt(2)/2,-.5>}rotate<0,0,45>}
		object{box{<0,0,-1>,<2,2,1>}}
	}
}
#declare copper_texture = texture{pigment { 
	color Brown}
	normal{
      quilted
      normal_map {
        [0.2 marble turbulence 0.4]
        [0.4 facets coords 0.3 scale 0.3]
        [0.6 facets coords 0.3 scale 0.3]
        [0.7 marble turbulence 0.4]
       }
	   scale 4
	}
	finish{ambient 0.2}
} 
#declare copper_texture2 = texture{pigment { 
	color Salmon}
	normal{
      waves
      normal_map {
        [0.2 marble turbulence 0.4]
        [0.4 facets coords 0.3 scale 0.3]
        [0.6 facets coords 0.3 scale 0.3]
        [0.7 marble turbulence 0.4]
       }
	}
	finish{ambient 0.2}
} 

#declare rail_texture = texture{pigment {
	color Gray70
}}
#declare start_ring = 0;
#declare distance_ring = paksize/2;
#declare ring_radius = 10;
#declare ring_center_height =3;
#declare car_width = 9;
#declare car_height = 18;
#declare base_width = car_width;//sqrt(ring_radius*ring_radius-ring_center_height*ring_center_height);
#declare backet_width = 22;
#declare rail_distance = 7;
#declare rail_width = 1;
#declare rail_startpoint = start_ring;
#declare rail_length = -paksize/2+start_ring; 
#declare rotation_core_radius=2;
#declare rail = 
object{merge{
	object{box{<paksize/4-rail_distance/2,0,rail_startpoint+1>,<paksize/4-rail_distance/2+rail_width,-.001,rail_startpoint-rail_length+1>}texture{pigment{color Gray30}finish{emission .5}}}
	object{box{<paksize/4-rail_distance/2,-.001,rail_startpoint+1>,<paksize/4-rail_distance/2+rail_width,-rail_width,rail_startpoint-rail_length>}texture{pigment{color Brown}}}
	object{box{<paksize/4+rail_distance/2,0,rail_startpoint+1>,<paksize/4+rail_distance/2-rail_width,-0.001,rail_startpoint-rail_length+1>}texture{pigment{color Gray30}finish{emission .5}}}
	object{box{<paksize/4+rail_distance/2,-.001,rail_startpoint+1>,<paksize/4+rail_distance/2-rail_width,-rail_width-0.001,rail_startpoint-rail_length>}texture{pigment{color Brown}}}
}
translate<0,.499,0>
}
#declare rail_basement_height=6;
#declare rail_basement =
object{
	merge{
		box{<(paksize/2-rail_distance)/2-rail_width,-rail_width+0.5,rail_startpoint>,<(paksize/2-rail_distance)/2+rail_width*2,-rail_basement_height,rail_startpoint-rail_length>}
		box{<(paksize/2+rail_distance)/2+rail_width,-rail_width+0.5,rail_startpoint>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,rail_startpoint-rail_length>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,0>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,8-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,8+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,16-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,16+1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,24-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,24+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,32-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,32+1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,40-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,40+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,48-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,48+1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,56-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,56+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,64-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,64>}
	}
	texture{rail_texture}
}
#declare basement_texture = texture{pigment{color Gray20}normal{
      gradient x 
      normal_map {
        [0.2 marble turbulence 0.4]
        [0.4 facets coords 0.3 scale 0.3]
        [0.6 facets coords 0.3 scale 0.3]
        [0.7 marble turbulence 0.4]
       }
}}

#declare bg_box=
object{
	merge{
		object{box{<0,-0.00001,0>,<paksize/2,-paksize/4,-0.00001>}}
		object{box{<0,-0.00001,0>,<-0.00001,-paksize/4,paksize/2>}}
		object{box{<paksize/2,-0.00001,paksize/2>,<0,-paksize/4,paksize/2+0.00001>}}
		object{box{<paksize/2,-0.00001,paksize/2>,<paksize/2+0.00001,-paksize/4,0>}}
	}
	texture{bg_texture}
}
#declare backet_texture=texture{pigment{color Gray70}normal{
      gradient x 
      normal_map {
        [0.2 marble turbulence 0.4]
        [0.4 facets coords 0.3 scale 0.3]
        [0.6 facets coords 0.3 scale 0.3]
        [0.7 marble turbulence 0.4]
       }
}}
#declare backet_side_basement=
object{
	merge{
		object{box{<0,0,0>,<(paksize/2-backet_width)/2,0,distance_ring>}}
		object{box{<paksize/2,0,0>,<(paksize/2+backet_width)/2,0,distance_ring>}}
		// object{box{<(paksize/2-backet_width)/2,0,start_ring>,<(paksize/2+backet_width)/2,0,0>}}
	}
	texture{basement_texture}
}
#declare backet=
object{
	merge{
		object{
			dam_tri
			rotate<0,-90,0>
			scale<64,ring_radius,2>
			translate<32,-ring_radius,0>
		}
		object{
			dam_tri
			rotate<0,-90,0>
			scale<64,ring_radius,-2>
			translate<32,-ring_radius,distance_ring>
		}
		object{
			dam_tri
			scale<4,ring_radius,distance_ring>
			translate<(paksize/2-backet_width)/2,-ring_radius,distance_ring/2>
		}
		object{
			dam_tri
			scale<-4,ring_radius,distance_ring>
			translate<(paksize/2+backet_width)/2,-ring_radius,distance_ring/2>
		}
	}
	texture{backet_texture}
}
#declare sand=
object{
	box{<0,-ring_radius,0>,<64,-ring_radius+.01,distance_ring>}
	texture{
		pigment{
			bozo
            color_map {
              [0.1 color Gray10]
			  [0.2 color OldGold]
			  [0.3 color MidnightBlue]
			  [0.5 color Gray20]
			  [0.7 color Black]
			  [0.8 color IndianRed]
            }
			scale .5
		}
		normal{
			agate 1
			scale 2
		}
		finish{
			emission 0.5
		}
	}
}

#declare sidewall_texture=texture{pigment{color Goldenrod}finish{ambient 0.4}}
#declare sidewall_width=4;
#declare sidewall_front=
merge{
	object{
		merge{
			// hor
			object{box{<(paksize/2+backet_width)/2,2,distance_ring>,<(paksize/2+backet_width)/2+.001,3,0>}}
			object{box{<(paksize/2+backet_width)/2,4,distance_ring>,<(paksize/2+backet_width)/2+.001,5,0>}}
			// ver
			object{box{<(paksize/2+backet_width)/2,0,00+0>,<(paksize/2+backet_width)/2-0.001,5,00+1>}}
			object{box{<(paksize/2+backet_width)/2,0,08+0>,<(paksize/2+backet_width)/2-0.001,5,08+1>}}
			object{box{<(paksize/2+backet_width)/2,0,16+0>,<(paksize/2+backet_width)/2-0.001,5,16+1>}}
			object{box{<(paksize/2+backet_width)/2,0,24+0>,<(paksize/2+backet_width)/2-0.001,5,24+1>}}
			object{box{<(paksize/2+backet_width)/2,0,32+0>,<(paksize/2+backet_width)/2-0.001,5,32+1>}}
			object{box{<(paksize/2+backet_width)/2,0,40+0>,<(paksize/2+backet_width)/2-0.001,5,40+1>}}
			object{box{<(paksize/2+backet_width)/2,0,48+0>,<(paksize/2+backet_width)/2-0.001,5,48+1>}}
			object{box{<(paksize/2+backet_width)/2,0,56+0>,<(paksize/2+backet_width)/2-0.001,5,56+1>}}
			object{box{<(paksize/2+backet_width)/2,0,64+0>,<(paksize/2+backet_width)/2-0.001,5,64-1>}}
			object{box{<(paksize/2+backet_width)/2,0,-1>,<(paksize/2+backet_width)/2-sidewall_width,0.0001,64>}}
		}
		translate<0,0,1>
		texture{sidewall_texture}
	}
	object{
		merge{
			object{box{<(paksize/2+rail_distance)/2,0,04+0>,<(paksize/2+backet_width)/2-0.001,-2,04+1>}}
			object{box{<(paksize/2+rail_distance)/2,0,12+0>,<(paksize/2+backet_width)/2-0.001,-2,12+1>}}
			object{box{<(paksize/2+rail_distance)/2,0,20+0>,<(paksize/2+backet_width)/2-0.001,-2,20+1>}}
			object{box{<(paksize/2+rail_distance)/2,0,28+0>,<(paksize/2+backet_width)/2-0.001,-2,28+1>}}
			object{box{<(paksize/2+rail_distance)/2,0,36+0>,<(paksize/2+backet_width)/2-0.001,-2,36+1>}}
			object{box{<(paksize/2+rail_distance)/2,0,44+0>,<(paksize/2+backet_width)/2-0.001,-2,44+1>}}
			object{box{<(paksize/2+rail_distance)/2,0,52+0>,<(paksize/2+backet_width)/2-0.001,-2,52+1>}}
			object{box{<(paksize/2+rail_distance)/2,0,60+0>,<(paksize/2+backet_width)/2-0.001,-2,60+1>}}
		}
		texture{copper_texture2}
	}
}
#declare sidewall_back=
merge{
	object{
		merge{
			// hor
			object{box{<(paksize/2-backet_width)/2,2,distance_ring>,<(paksize/2-backet_width)/2+.001,3,0>}}
			object{box{<(paksize/2-backet_width)/2,4,distance_ring>,<(paksize/2-backet_width)/2+.001,5,0>}}
			// ver
			object{box{<(paksize/2-backet_width)/2,0,00+0>,<(paksize/2-backet_width)/2-0.001,5,00+1>}}
			object{box{<(paksize/2-backet_width)/2,0,08+0>,<(paksize/2-backet_width)/2-0.001,5,08+1>}}
			object{box{<(paksize/2-backet_width)/2,0,16+0>,<(paksize/2-backet_width)/2-0.001,5,16+1>}}
			object{box{<(paksize/2-backet_width)/2,0,24+0>,<(paksize/2-backet_width)/2-0.001,5,24+1>}}
			object{box{<(paksize/2-backet_width)/2,0,32+0>,<(paksize/2-backet_width)/2-0.001,5,32+1>}}
			object{box{<(paksize/2-backet_width)/2,0,40+0>,<(paksize/2-backet_width)/2-0.001,5,40+1>}}
			object{box{<(paksize/2-backet_width)/2,0,48+0>,<(paksize/2-backet_width)/2-0.001,5,48+1>}}
			object{box{<(paksize/2-backet_width)/2,0,56+0>,<(paksize/2-backet_width)/2-0.001,5,56+1>}}
			object{box{<(paksize/2-backet_width)/2,0,64+0>,<(paksize/2-backet_width)/2-0.001,5,64-1>}}
			object{box{<(paksize/2-backet_width)/2,0,-1>,<(paksize/2-backet_width)/2+sidewall_width,0.0001,64>}}
		}
		translate<0,0,1>
		texture{sidewall_texture}
	}
	object{
		merge{
			object{box{<(paksize/2-backet_width)/2,0,04+0>,<(paksize/2-rail_distance)/2-0.001,-2,04+1>}}
			object{box{<(paksize/2-backet_width)/2,0,12+0>,<(paksize/2-rail_distance)/2-0.001,-2,12+1>}}
			object{box{<(paksize/2-backet_width)/2,0,20+0>,<(paksize/2-rail_distance)/2-0.001,-2,20+1>}}
			object{box{<(paksize/2-backet_width)/2,0,28+0>,<(paksize/2-rail_distance)/2-0.001,-2,28+1>}}
			object{box{<(paksize/2-backet_width)/2,0,36+0>,<(paksize/2-rail_distance)/2-0.001,-2,36+1>}}
			object{box{<(paksize/2-backet_width)/2,0,44+0>,<(paksize/2-rail_distance)/2-0.001,-2,44+1>}}
			object{box{<(paksize/2-backet_width)/2,0,52+0>,<(paksize/2-rail_distance)/2-0.001,-2,52+1>}}
			object{box{<(paksize/2-backet_width)/2,0,60+0>,<(paksize/2-rail_distance)/2-0.001,-2,60+1>}}
		}
		texture{copper_texture2}
	}
}
#declare roof = 
object{
	merge{
		box{<2,0,00+0>,<0,23,00+1>}
		// box{<(paksize/2+backet_width)/2+2,0,16-1>,<(paksize/2+backet_width)/2+4,24,16+1>}
		box{<2,0,32-1>,<0,23,32+1>}
		// box{<(paksize/2+backet_width)/2+2,0,48-1>,<(paksize/2+backet_width)/2+4,24,48+1>}
		box{<2,0,64-1>,<0,23,64+0>}
		box{<paksize/2-2,0,00+0>,<paksize/2,23,00+1>}
		// box{<(paksize/2-backet_width)/2-2,0,16-1>,<(paksize/2-backet_width)/2-4,24,16+1>}
		box{<paksize/2-2,0,32-1>,<paksize/2,23,32+1>}
		// box{<(paksize/2-backet_width)/2-2,0,48-1>,<(paksize/2-backet_width)/2-4,24,48+1>}
		box{<paksize/2-2,0,64-1>,<paksize/2,23,64+0>}
		object{naname(<paksize/2,23,32>,<paksize/4-1,32,32>,64,1)}
		object{naname(<0,23,32>,<paksize/4+1,32,32>,64,1)}
		object{naname(<paksize/2,0,1>,<paksize/2,23,31>,1,1)}
		object{naname(<paksize/2,0,33>,<paksize/2,23,63>,1,1)}
		object{naname(<0,0,1>,<0,23,31>,1,1)}
		object{naname(<0,0,33>,<0,23,63>,1,1)}
		object{naname(<paksize/2,23,1>,<paksize/2,1,31>,1,1)}
		object{naname(<paksize/2,23,33>,<paksize/2,1,63>,1,1)}
		object{naname(<0,23,1>,<0,1,31>,1,1)}
		object{naname(<0,23,33>,<0,1,63>,1,1)}
	}
	texture{copper_texture2}
}

#declare pier_size = 4;
#declare pier_naname=6;
#declare pier =
object{
	intersection{
		object{box{<0,0,paksize/2>,<paksize/2,paksize/4-rail_basement_height,paksize/2-pier_size>}}
		object{merge{
			object{naname(<(paksize/2-rail_distance)/2-pier_naname,0,paksize/2-pier_size/2>,<(paksize/2-rail_distance)/2,paksize/4,paksize/2-pier_size/2>,pier_size+0.01,pier_size+0.01)}
			object{naname(<(paksize/2+rail_distance)/2+pier_naname,0,paksize/2-pier_size/2>,<(paksize/2+rail_distance)/2,paksize/4,paksize/2-pier_size/2>,pier_size+0.01,pier_size+0.01)}
			object{box{<(paksize/2-rail_distance)/2-pier_naname,pier_size,paksize/2+0.001>,<(paksize/2+rail_distance/2)/2+pier_naname,pier_size*2,paksize/2-pier_size>}}
		}}
	}
	texture{rail_texture}
}
#declare sekitan=
object{
intersection{
	object{
		box{<0,0,0>,<paksize/2,paksize/2,paksize/2>}
	}
	object{
		box{<-paksize/8,-paksize/8,0-.0001>,<paksize/8,paksize/8,paksize/2+.0001>}
		rotate<0,0,45>
		translate<paksize/4,0,0>
		scale<1,.3,1>
	}
}
texture{basement_texture}
normal{
	agate 1
	scale 4
}
}

#declare obj=
merge{
object{
merge{
	object{rail
	translate<0,32,0>}
	object{rail_basement
	translate<0,32,0>}
	object{pier
	translate<0,0,-paksize/8+pier_size/2>}
	object{pier
	translate<0,0,-paksize*3/8+pier_size/2>}	
	object{sidewall_front
	translate<0,32,0>}	
	object{sidewall_back
	translate<0,32,0>}
	// object{sekitan}
}
}
}
#declare rail_stopper=
object{
	merge{
		object{naname(<paksize/4-rail_distance/2,0,0>,<paksize/4-1,4,-1>,1,1)}
		object{naname(<paksize/4+rail_distance/2,0,0>,<paksize/4+1,4,-1>,1,1)}
		object{naname(<paksize/4-rail_distance/2+1,0,-5>,<paksize/4-1,4,-1>,1,1)}
		object{naname(<paksize/4+rail_distance/2-1,0,-5>,<paksize/4+1,4,-1>,1,1)}
		object{box{<paksize/4,4,-1>,<paksize/4+1,5,0>}texture{pigment{color Black}}}
		object{box{<paksize/4,4,-1>,<paksize/4-1,5,0>}texture{pigment{color White}}}
		object{box{<paksize/4,6,-1>,<paksize/4-1,5,0>}texture{pigment{color Black}}}
		object{box{<paksize/4,6,-1>,<paksize/4+1,5,0>}texture{pigment{color White}}}
	}
	texture{sidewall_texture}
}
#declare sidewall_end=
object{
	merge{
	object{naname(<(paksize/2+backet_width)/2-sidewall_width/2,paksize/4,paksize/4>,<(paksize/2+backet_width)/2-sidewall_width/2,paksize/8,paksize/4-pier_size>,sidewall_width,0.001)}
	object{naname(<(paksize/2-backet_width)/2+sidewall_width/2,paksize/4,paksize/4>,<(paksize/2-backet_width)/2+sidewall_width/2,paksize/8,paksize/4-pier_size>,sidewall_width,0.001)}
	object{box{<(paksize/2-backet_width)/2,paksize/8,paksize/4-pier_size>,<(paksize/2+backet_width)/2,paksize/8-.001,paksize/4-pier_size-sidewall_width>}}
	object{naname(<(paksize/2-backet_width)/2,0,paksize/4-pier_size-sidewall_width-sidewall_width/2>,<(paksize/2+backet_width)/2-sidewall_width,paksize/8,paksize/4-pier_size-sidewall_width-sidewall_width/2>,sidewall_width,0.001)}
	object{box{<(paksize/2+backet_width)/2,paksize/8,paksize/4-pier_size-sidewall_width>,<(paksize/2+backet_width)/2-sidewall_width,paksize/8-.0001,paksize/4-pier_size-sidewall_width*2>}}
	object{naname(<(paksize/2+backet_width)/2,paksize/4+4.5,paksize/4>,<(paksize/2+backet_width)/2,paksize/8+4.5,paksize/4-pier_size>,.0001,1)}
	object{naname(<(paksize/2-backet_width)/2,paksize/4+4.5,paksize/4>,<(paksize/2-backet_width)/2,paksize/8+4.5,paksize/4-pier_size>,.0001,1)}
	object{naname(<(paksize/2-backet_width)/2,paksize/8+4.5,paksize/4-pier_size-sidewall_width>,<(paksize/2+backet_width)/2-sidewall_width,paksize/8+4.5,paksize/4-pier_size-sidewall_width>,.0001,1)}
	object{box{<(paksize/2-backet_width)/2,paksize/8+4,paksize/4-pier_size>,<(paksize/2-backet_width)/2,paksize/8+5,paksize/4-pier_size-sidewall_width>}}
	object{box{<(paksize/2+backet_width)/2-sidewall_width-1,paksize/8,paksize/4-pier_size-sidewall_width>,<(paksize/2+backet_width)/2-sidewall_width,paksize/8+5,paksize/4-pier_size-sidewall_width>}}
	object{box{<(paksize/2-backet_width)/2+1,paksize/8,paksize/4-pier_size-sidewall_width>,<(paksize/2-backet_width)/2,paksize/8+5,paksize/4-pier_size-sidewall_width>}}
	object{naname(<(paksize/2-backet_width)/2,0+4.5,paksize/4-pier_size-sidewall_width>,<(paksize/2+backet_width)/2-sidewall_width,paksize/8+4.5,paksize/4-pier_size-sidewall_width>,.0001,1)}
	object{naname(<(paksize/2-backet_width)/2,0+4.5,paksize/4-pier_size-sidewall_width-sidewall_width>,<(paksize/2+backet_width)/2-sidewall_width,paksize/8+4.5,paksize/4-pier_size-sidewall_width-sidewall_width>,.0001,1)}
	object{box{<(paksize/2-backet_width)/2+1,0,paksize/4-pier_size-sidewall_width*2>,<(paksize/2-backet_width)/2,0+5,paksize/4-pier_size-sidewall_width*2>}}
	object{box{<(paksize/2-backet_width)/2+1,0,paksize/4-pier_size-sidewall_width>,<(paksize/2-backet_width)/2,0+5,paksize/4-pier_size-sidewall_width>}}
	object{box{<(paksize/2+backet_width)/2,paksize/8,paksize/4-pier_size-sidewall_width*2>,<(paksize/2+backet_width)/2,paksize/8+5,paksize/4-pier_size-sidewall_width*2+1>}}
	object{box{<(paksize/2+backet_width)/2,paksize/8,paksize/4-pier_size>,<(paksize/2+backet_width)/2,paksize/8+5,paksize/4-pier_size+1>}}
	object{box{<(paksize/2+backet_width)/2,paksize/8+4,paksize/4-pier_size>,<(paksize/2+backet_width)/2,paksize/8+5,paksize/4-pier_size-sidewall_width*2>}}
	object{box{<(paksize/2+backet_width)/2,paksize/8+4,paksize/4-pier_size-sidewall_width*2>,<(paksize/2+backet_width)/2-sidewall_width,paksize/8+5,paksize/4-pier_size-sidewall_width*2>}}
	}
	texture{sidewall_texture}
}
#declare obj_end=
merge{
	object{
		intersection{
			merge{
				object{rail
				translate<0,32,0>}
				object{rail_basement
				translate<0,32,0>}
				object{pier
				translate<0,0,-paksize/8+pier_size/2>}
				object{sidewall_front
				translate<0,32,0>}
				object{sidewall_back
				translate<0,32,0>}
				// object{sekitan}
			}
			object{box{<0,0,paksize/8>,<paksize/2,paksize/2,paksize/2+1>}}
		}
	}
	object{
		merge{
		object{pier
		translate<0,0,-paksize*3/8>}
		object{box{<(paksize/2-rail_distance)/2-rail_width*2,-rail_width+0.5,0>,<(paksize/2+rail_distance)/2+rail_width*2,-rail_basement_height,-pier_size>}
		translate<0,32,paksize/8>
		texture{rail_texture}
		}
		}
	}
	object{rail_stopper
	translate<0,paksize/4,paksize/8+5>}
	object{sidewall_end
	translate<0,0,-paksize/8>}
}

#declare obj_diagonal=
intersection{
	object{box{<0,0,0>,<paksize/2,paksize/2,paksize/2>}texture{basement_texture}}
	object{merge{
		object{obj
		translate<0,0,-paksize/2>
		scale<1/sqrt(2),1,1/sqrt(2)>
		rotate<0,45,0>
		translate<0,0,paksize/2>}
		object{obj
		scale<1/sqrt(2),1,1/sqrt(2)>
		rotate<0,45,0>
		translate<0,0,paksize/2>}
	}}
}

#declare obj_4_dir=
intersection{
union {
	object{pier}
	object{pier
	translate<0,0,-paksize/2+pier_size>}
	object{pier
	rotate<0,90,0>
	translate<0,0,paksize/2>}
	object{pier
	rotate<0,90,0>
	translate<-paksize/2+pier_size,0,paksize/2>}
	object{rail
	translate<0,32,0>}
	object{rail_basement
	translate<0,32,0>}
	object{rail
	rotate<0,90,0>
	translate<0,32,paksize/2>}
	object{rail_basement
	rotate<0,90,0>
	translate<0,32,paksize/2>}
	object{rail
	translate<0,32,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>}
	object{rail
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>}
	object{rail_basement
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>}
	object{rail_basement
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>}
	object{rail
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,90,0>
	translate<0,32,paksize/2>}
	object{rail
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,90,0>
	translate<0,32,paksize/2>}
	object{rail_basement
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,90,0>
	translate<0,32,paksize/2>}
	object{rail_basement
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,90,0>
	translate<0,32,paksize/2>}

	
	object{rail
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,180,0>
	translate<paksize/2,32,paksize/2>}
	object{rail
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,180,0>
	translate<paksize/2,32,paksize/2>}
	object{rail_basement
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,180,0>
	translate<paksize/2,32,paksize/2>}
	object{rail_basement
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,180,0>
	translate<paksize/2,32,paksize/2>}
	
	object{rail
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,270,0>
	translate<paksize/2,32,0>}
	object{rail
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,270,0>
	translate<paksize/2,32,0>}
	object{rail_basement
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,270,0>
	translate<paksize/2,32,0>}
	object{rail_basement
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,0,paksize/2>
	rotate<0,270,0>
	translate<paksize/2,32,0>}
	
	object{sidewall_back
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>
	rotate<0,90,0>
	translate<0,0,paksize/2>}
	object{sidewall_back
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>
	rotate<0,90,0>
	translate<0,0,paksize/2>}	
	object{sidewall_back
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>}
	object{sidewall_back
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>}	
	object{sidewall_back
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>
	rotate<0,180,0>
	translate<paksize/2,0,paksize/2>}
	object{sidewall_back
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>
	rotate<0,180,0>
	translate<paksize/2,0,paksize/2>}	
	object{sidewall_back
	translate<0,0,-paksize/2>
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>
	rotate<0,270,0>
	translate<paksize/2,0,0>}
	object{sidewall_back
	scale<1/sqrt(2),1,1/sqrt(2)>
	rotate<0,45,0>
	translate<0,32,paksize/2>
	rotate<0,270,0>
	translate<paksize/2,0,0>}
}
object{box{<-.00001,0,-.00001>,<paksize/2+.0001,paksize/2,paksize/2+.0001>}texture{basement_texture}}
}







// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
merge{
// object{difference {
object{merge{
	object{obj}
	// object{difference{
	// object{
	// box{<-paksize/2,paksize/4,paksize/4>*1.414,<paksize/2+1,-paksize/4,-paksize/4>*1.414}
	// rotate<45,0,0>
	// scale<1,.5,1>*.95
	// }
	// object{
	// 	box{<paksize/4,-1,paksize/4>*1.414,<-paksize/4,paksize,-paksize/4>*1.414}
	// 	rotate<0,45,0>
	// 	scale<1,1,.5/1.414>
	// 	translate<paksize/4,0,paksize/2>
	// }
	// }}
	//object{box{<0,-32,0>,<32,64,32>}texture{bg_texture}}
}}
// object{
// 	rail
// 	translate<0,.249,0>
// }
}
#declare output_obj_end =
object{obj_end}
#declare output_obj_front=
object{obj_diagonal}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_z)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_z,paksize*(max(int_x,int_z)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj_end}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj_end
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{merge{object{output_obj_end}
		}
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{merge{object{output_obj_end}
		}
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
// #declare make_front_image=1;
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_z)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_z,paksize*(max(int_x,int_z)+2)/2>}}
#end
object{merge{
	object{
	intersection{object{output_obj_front}
	// object{output_area_set_z}
	}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj_front
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	// object{output_area_set_x}
	}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj_front
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	// object{output_area_set_z}
	}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj_front
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	// object{output_area_set_x}
	}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	translate<-1,0,-1>*paksize
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
		intersection{object{obj_4_dir
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	// object{output_area_set_x}
	}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}
	}
	translate<-1,0,-1>*paksize*(-1)
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
