#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"


// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=128;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128*1000
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2*3
	}


// ---light setting---
light_source {
	<0,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare rope_height=21.5;
#declare ring_angle=-30;
#declare ring_texture=texture{pigment{color BakersChoc}}
#declare rope_guide_texture=texture{pigment{color Brown}}
#declare rope_texture=texture{pigment{color Gray15}}
#declare ring=
object{
	intersection{
		object{
			merge{
				object{
					difference{
						object{cylinder{<0,-1,0>,<0,2,0>,32}}
						object{cylinder{<0,-2,0>,<0,3,0>,24}}
					}
				}
				object{box{<-4,-1,-24>,<4,2,24>}rotate<0,ring_angle,0>}
				object{box{<-4,-1.0001,-24>,<4,2.00003,24>}rotate<0,ring_angle+45,0>}
				object{box{<-4,-1.0002,-24>,<4,2.00005,24>}rotate<0,ring_angle+90,0>}
				object{box{<-4,-1.0003,-24>,<4,2.0001,24>}rotate<0,ring_angle+135,0>}
				object{
					difference{
						object{cylinder{<0,0,0>,<0,1,0>,32.01}texture{rope_texture}}
						object{cylinder{<0,-1,0>,<0,2,0>,31.9}}
						object{box{<0,-1,-64>,<32,2,64>}}
					}
				}
			}
			translate<paksize/4,rope_height,0>
		}
		object{box{<-.5,0,0>,<paksize/2,paksize/2,paksize/2>}}
	}
	texture{ring_texture}
}
#declare rail=
merge{
object{box{<0,rope_height,32>,<32,rope_height+2,32>}texture{rope_guide_texture}}
object{box{<64,rope_height,32>,<32,rope_height+1,32>}texture{rope_texture}}
}
#declare motor=
object{
	intersection{
		object{
			merge{
				cylinder{<32,0,0>,<32,rope_height-1,0>,12}
			}
		}
		object{box{<-.5,0,0>,<paksize/2,paksize/2,paksize/2>}}
	}
	texture{ring_texture}
}
#declare hook=
object{
	merge{
		object{box{<30,rope_height-4,31>,<34,rope_height-6,1>}}
		object{box{<24,rope_height-3,30>,<40,rope_height-5,32>}}
	}
	texture{ring_texture}
}


#declare obj=
merge{
	object{ring}
}
#declare bg_obj=
merge{
	object{motor}
	object{hook}
}












// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
object{
	merge{
		object{obj}
		object{rail}
	}
}
#declare output_obj3=
object{
	merge{
		object{
			output_obj
		}
		object{
			bg_obj
		}
	}
}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_z)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_z,paksize*(max(int_x,int_z)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj3
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj3
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*(-paksize)
	// translate<-.25,0,-.25>
}
#declare output_obj2=
object{
	merge{
		object{obj}
		object{rail
		scale<-1,1,1>
		translate<64,0,0>}
	}
}
#declare output_obj4=
object{
	merge{
		object{
			output_obj2
		}
		object{
			bg_obj
		}
	}
}
object{merge{
	object{
	intersection{object{output_obj2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj2
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj4
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj4
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*0*paksize
}
#declare output_obj5=
object{
	merge{
		object{
			bg_obj
		}
	}
}
object{merge{
	object{
	intersection{object{output_obj5}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj5
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj5
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj5
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*1*paksize
}

